import { ConditionInterface } from "./ConditionInterface";
import { ConditionOperand } from "./ConditionOperands/ConditionOperand";
export declare enum Operator {
    Equals = "equals",
    NotEquals = "not_equals",
    Less = "less",
    LessOrEqual = "less_or_equal",
    Greater = "greater",
    GreaterOrEqual = "greater_or_equal",
    Contains = "contains",
    Regexp = "regexp",
    '==' = "equals",
    '!=' = "not_equals",
    '<' = "less",
    '<=' = "less_or_equal",
    '>' = "greater",
    '>=' = "greater_or_equal",
    'contains' = "contains",
    'regexp' = "regexp"
}
export declare namespace Operator {
    function isValidKey(value: string): boolean;
    function isValidValue(value: string): boolean;
}
export declare function createCondition(operandLhs: ConditionOperand, operator: Operator | string, operandRhs: ConditionOperand | number | string | boolean, duration?: number): Condition;
export declare class Condition implements ConditionInterface {
    private readonly operandLhs;
    private readonly operator;
    private readonly operandRhs;
    private readonly duration;
    constructor(operandLhs: ConditionOperand, operator: Operator | string, operandRhs: ConditionOperand, duration?: number);
    evaluate(...eventParameters: any[]): boolean;
    private compareOperands;
    private contains;
    private evalRegexp;
    private getOperands;
    private isValidRegularExpression;
}
