import { Operator } from "../Condition";
export type Parameter = {
    name: string;
    title: string;
    description?: string;
    type: 'label' | 'integer' | 'float' | 'string' | 'boolean' | 'json' | 'list' | 'file';
    default?: string | number | boolean | Array<unknown> | Record<string, unknown>;
    defaultValue?: string | number | boolean | Array<unknown> | Record<string, unknown>;
    validator?: string;
    min?: number;
    max?: number;
    placeholder?: number | string;
    options?: ParameterOption[];
    label?: string;
    orderId?: number;
};

export type ParameterOption = {
    label: string;
    value: string;
};

export type Actions = {
    type: 'wizard' | 'code';
    steps: Step[];
    code: string;
};

export enum StepType {
    MethodCall = 'MethodCall',
    EventEmit = 'EventEmit',
    Timeout = 'Timeout',
    Log = 'Log'
}

export type Step = {
    name: string;
    description: string;
    type: StepType;
    step: MethodCallStep | EventEmitStep | TimeoutStep | LogStep;
};

export type MethodCallStep = {
    instanceId: string;
    methodName: string;
    methodParameters: Parameter[];
  };

export type EventEmitStep = {
    eventName: string;
    eventParameters: Parameter[];
};

export type TimeoutStep = {
    waitTimeMs: number;
};

export type LogStep = {
    message: string;
};

export type ModuleMethod = {
    name: string;
    parameters: Parameter[];
    actions: Actions;
    description?: string;
    orderId?: number;
    returnType?: string;
    factory?: boolean;
};

export type ModuleEvent = {
    name: string;
    description: string;
    baseEventTemplateName?: string;
    callbackParameters: Parameter[];
    parameterValues: string[];
    subscriptionMethodCode: string;
    actions: Actions;
    orderId?: number;
    factory?: boolean;
};

export type ModuleRule = {
    name: string;
    event: ModuleRuleEvent;
    actions: Actions;
    conditions: ConditionsList;
};

export type ModuleRuleEvent = {
    instanceId: string;
    event: string;
};

export type ModuleProperty = {
    name: string;
    orderId?: number;
    factory?: boolean;
};

export type ModuleVariable = {
    name: string;
    type: string;
    defaultValue: unknown;
    description: string;
    orderId: number;
    factory: boolean;
};

export type ConditionsList = {
    any: ModuleDescriptorCondition[];
    every: ModuleDescriptorCondition[];
};

export type ModuleDescriptorCondition = {
    left: ConditionLeft;
    operator: Operator;
    right: ConditionRight;
};

export type ConditionLeft = {
    type: ConditionLeftType;
    instanceId?: string;
    name: string;
    index?: number;
};

export type ConditionRight = {
    type: ConditionRightType;
    instanceId?: string;
    name?: string;
    index?: number;
    value: unknown;
};

export enum ConditionLeftType {
    EventCallbackParameter = 'eventCallbackParameter',
    StatusVariable = 'StatusVariable'
}

export enum ConditionRightType {
    EventCallbackParameter = 'eventCallbackParameter',
    StatusVariable = 'StatusVariable',
    Constant = 'Constant'
}

export type DeviceChildren = Record<
    string,
    ModuleDescriptorMethod | ModuleDescriptorEvent | ModuleDescriptorProperty | ModuleDescriptorVariable
>;

export type ModuleDescriptorSchema = {
    Schemas: Record<string, unknown>;
    Devices: Record<string, Device>;
};

export type Device = {
    name: string;
    type: string;
    children: DeviceChildren;
    extensions: DeviceChildren;
    rules: ModuleRule[];
};

export type ModuleDescriptorMethod = ModuleMethod & { type: 'method' };
export type ModuleDescriptorEvent = ModuleEvent & { type: 'event' };
export type ModuleDescriptorProperty = ModuleProperty & { type: 'property' };
export type ModuleDescriptorVariable = {
    type: 'variable';
    valueType: string;
    defaultValue: unknown;
    description: string;
    orderId: number;
    factory: boolean;
};
