import { EventDescriptor } from "./EventDescriptor";
import { MethodDescriptor } from "./MethodDescriptor";
import { VariableDescriptor } from "./VariableDescriptor";
export type ModuleDescriptorObject = {
    Schemas: Record<string, unknown>;
    Devices: Record<string, Device>;
};
export type Device = {
    name: string;
    type: string;
    children: Record<string, any>;
    extensions: Record<string, any>;
    rules: any[];
};
export type Descriptors = MethodDescriptor | EventDescriptor | VariableDescriptor;
export declare enum ValueTypeTag {
    String = "string",
    Number = "number",
    Boolean = "boolean",
    Array = "Array<unknown>",
    Record = "Record<string, unknown>"
}
export type ValueType = string | number | boolean | Array<unknown> | Record<string, unknown>;
export type Parameter = {
    name: string;
    title: string;
    description?: string;
    type: 'label' | 'integer' | 'float' | 'string' | 'boolean' | 'json' | 'list' | 'file';
    default?: ValueType;
    defaultValue?: ValueType;
    validator?: string;
    min?: number;
    max?: number;
    placeholder?: number | string;
    options?: ParameterOption[];
    label?: string;
    orderId?: number;
};
export declare enum ElementType {
    Method = "method",
    Event = "event",
    Rule = "rule",
    Variable = "variable"
}
export type ParameterOption = {
    label: string;
    value: string;
};
