import { MethodDescriptor } from "./MethodDescriptor";

describe('MethodDescriptor', () => {
  describe('getMethodsFromEntryCode', () => {
    test('Successfully returns a method', () => {
      const entryCode = `
      /* Methods */
      /**
       * @method test1
       * @param {string} test
       * @returns {any}
       * @description {test}
       */
      async test1(test) {
        console.log(1)
      }
      /* Methods end */
      `;
      const expected = {
        test1: {
          returnType: 'any',
          code: '        console.log(1)\n      ',
          description: 'test'
        }
      };

      const result = MethodDescriptor.getMethodsFromEntryCode(entryCode);

      expect(result).toEqual(expected);
    });

    test('Successfully returns multiple methods', () => {
      const entryCode = `
      /* Methods */
      /**
       * @method test1
       * @param {string} test
       * @returns {any}
       * @description {test}
       */
      async test1(test) {
        console.log(1)
      }
    
      /**
       * @method test2
       * @param {string} test
       * @returns {any}
       * @description {test}
       */
      async test2(test) {
        console.log(2)
      }
      /* Methods end */
      `;

      const expected = {
        test1: {
          returnType: 'any',
          code: '        console.log(1)\n      ',
          description: 'test'
        },
        test2: {
          returnType: 'any',
          code: '        console.log(2)\n      ',
          description: 'test'
        }
      };

      const result = MethodDescriptor.getMethodsFromEntryCode(entryCode);

      expect(result).toEqual(expected);
    });
  });
});
