"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Triggers = void 0;
const node_events_1 = require("node:events");
const common_1 = require("./common");
class Triggers {
    constructor() {
        this.triggers = [];
        this.eventEmitter = new node_events_1.EventEmitter();
    }
    addTrigger(trigger) {
        trigger.onTriggered((...args) => {
            this.eventEmitter.emit(common_1.triggeredEventName, ...args);
        });
        this.triggers.push(trigger);
        return this;
    }
    onTriggered(listener) {
        this.eventEmitter.on(common_1.triggeredEventName, listener);
    }
    removeListener() {
        this.eventEmitter.removeAllListeners(common_1.triggeredEventName);
    }
}
exports.Triggers = Triggers;
//# sourceMappingURL=Triggers.js.map