"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const Trigger_1 = require("./Trigger");
const module_descriptor_1 = require("@lightware/module-descriptor");
class VariableChangedTrigger extends Trigger_1.Trigger {
    constructor(variable, durationMs = 0, onInit = false) {
        super(module_descriptor_1.TriggerType.VariableChanged, durationMs);
        this.variable = variable;
        const onChangedHandler = (_currentValue, _previousValue) => {
            this.reset();
            this.start();
        };
        this.variable.onChanged(onChangedHandler);
        if (onInit) {
            onChangedHandler(this.variable.value, this.variable.previousValue);
        }
    }
}
exports.default = VariableChangedTrigger;
//# sourceMappingURL=VariableChangedTrigger.js.map