"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const variable_api_1 = require("@lightware/variable-api");
const VariableChangedMessage_1 = require("@lightware/variable-api/dist/src/Communication/VariableChangedMessage");
const VariableStateMessageData_1 = require("@lightware/variable-api/dist/src/Communication/VariableStateMessageData");
const VariableChangedTrigger_1 = __importDefault(require("./VariableChangedTrigger"));
jest.useFakeTimers();
describe('VariableChanged trigger tests', () => {
    test('After variable changes the trigger has to be fired immediately.', () => {
        const remoteVariable = new variable_api_1.RemoteVariable("variable", "");
        const instanceApiMock = { getInstanceById: jest.fn().mockReturnValue({ variables: { variable: remoteVariable } }) };
        const variableTrigger = new VariableChangedTrigger_1.default(remoteVariable);
        const triggeredHandler = jest.fn();
        variableTrigger.onTriggered(triggeredHandler);
        const data = new VariableStateMessageData_1.VariableStateMessageData("variable", '', variable_api_1.TypeSignature.Number, 35, 21, performance.now());
        const msg = new VariableChangedMessage_1.VariableChangedMessage('msgid', '', '', data);
        remoteVariable.onMessage(msg);
        expect(triggeredHandler).toHaveBeenCalledTimes(1);
    });
    test('After variable changes the trigger has to be fired after 1 seconds.', () => {
        const remoteVariable = new variable_api_1.RemoteVariable("variable", "");
        const instanceApiMock = { getInstanceById: jest.fn().mockReturnValue({ variables: { variable: remoteVariable } }) };
        const variableTrigger = new VariableChangedTrigger_1.default(remoteVariable, 1000);
        const triggeredHandler = jest.fn();
        variableTrigger.onTriggered(triggeredHandler);
        const data = new VariableStateMessageData_1.VariableStateMessageData("variable", '', variable_api_1.TypeSignature.Number, 35, 21, performance.now());
        const msg = new VariableChangedMessage_1.VariableChangedMessage('msgid', '', '', data);
        remoteVariable.onMessage(msg);
        jest.advanceTimersByTime(1000);
        expect(triggeredHandler).toHaveBeenCalledTimes(1);
    });
    test('After variable changes the trigger has to be fired after 1 seconds. The event has to be fired only once', () => {
        const remoteVariable = new variable_api_1.RemoteVariable("variable", "");
        const variableTrigger = new VariableChangedTrigger_1.default(remoteVariable, 1000);
        let timeDifference = 0;
        const triggeredHandler = jest.fn();
        variableTrigger.onTriggered(triggeredHandler);
        variableTrigger.onTriggered(() => {
            timeDifference = performance.now() - timeDifference;
        });
        for (let i = 0; i < 5; i++) {
            timeDifference = performance.now();
            const currentValue = Math.ceil(Math.random() * 100);
            const data = new VariableStateMessageData_1.VariableStateMessageData("variable", '', variable_api_1.TypeSignature.Number, currentValue, 21, timeDifference);
            const msg = new VariableChangedMessage_1.VariableChangedMessage('msgid', '', '', data);
            remoteVariable.onMessage(msg);
        }
        jest.advanceTimersByTime(1000);
        expect(triggeredHandler).toHaveBeenCalledTimes(1);
        expect(timeDifference).toEqual(1000);
    });
});
//# sourceMappingURL=VariableChangedTrigger.test.js.map