import { EventEmitter } from "node:events";
import { Trigger } from "./Trigger";
import { triggeredEventName } from "./common";

export class Triggers {
  private triggers: Array<Trigger> = [];
  private readonly eventEmitter: EventEmitter = new EventEmitter();

  addTrigger(trigger: Trigger): Triggers {
    trigger.onTriggered((...args: any[]) => {
      this.eventEmitter.emit(triggeredEventName, ...args);
    });
    this.triggers.push(trigger);
    return this;
  }

  onTriggered(listener: (...triggerArgs: any[]) => void): void {
    this.eventEmitter.on(triggeredEventName, listener);
  }

  removeListener(): void {
    this.eventEmitter.removeAllListeners(triggeredEventName);
  }
}
