import { RemoteVariable } from "@lightware/variable-api";
import { Trigger } from "./Trigger";
import { TriggerType } from "@lightware/module-descriptor";

export default class VariableChangedTrigger extends Trigger {
  constructor(private readonly variable: RemoteVariable, durationMs = 0, onInit = false) {

    super(TriggerType.VariableChanged, durationMs);

    const onChangedHandler = (_currentValue: any, _previousValue: any): void => {
      this.reset();
      this.start();
    };

    this.variable.onChanged(onChangedHandler);

    if (onInit) {
      onChangedHandler(this.variable.value, this.variable.previousValue);
    }
  }
}
