"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SubscriptionManager = void 0;
class SubscriptionManager {
    constructor() {
        this.subscribers = [];
    }
    addSubscriber(instanceId, variableName, subscriber) {
        const index = this.subscribers.findIndex((sub) => sub.instanceId === instanceId && sub.variableName === variableName);
        if (index === -1) {
            const subscription = { instanceId: instanceId, variableName: variableName, subscribers: [subscriber] };
            this.subscribers.push(subscription);
        }
        else {
            if (!this.subscribers[index].subscribers.includes(subscriber)) {
                this.subscribers[index].subscribers.push(subscriber);
            }
        }
    }
    getSubscribers(instanceId, variableName) {
        const index = this.subscribers.findIndex((subscriber) => {
            return subscriber.instanceId === instanceId && subscriber.variableName === variableName;
        });
        if (index != -1) {
            return this.subscribers[index].subscribers;
        }
        return [];
    }
    reset() {
        this.subscribers.splice(0, this.subscribers.length);
    }
}
exports.SubscriptionManager = SubscriptionManager;
//# sourceMappingURL=SubscriptionManager.js.map