type Subscription = {
  instanceId: string;
  variableName: string;
  subscribers: Array<string>;
};

export class SubscriptionManager {
  private readonly subscribers: Array<Subscription> = [];

  constructor() {}

  addSubscriber(instanceId: string, variableName: string, subscriber: string): void {
    const index = this.subscribers.findIndex((sub) => sub.instanceId === instanceId && sub.variableName === variableName);

    if (index === -1) {
      const subscription: Subscription = {instanceId: instanceId, variableName: variableName, subscribers: [subscriber]};

      this.subscribers.push(subscription);
    } else {
      if (!this.subscribers[index].subscribers.includes(subscriber)) {
        this.subscribers[index].subscribers.push(subscriber);
      }
    }
  }

  getSubscribers(instanceId: string, variableName: string): Array<string> {
    const index = this.subscribers.findIndex((subscriber) => {
        return subscriber.instanceId === instanceId && subscriber.variableName === variableName;
      });

      if (index != -1) {
        return this.subscribers[index].subscribers;
      }

      return [];
  }

  reset(): void {
    this.subscribers.splice(0, this.subscribers.length);
  }
}
