import { parseMessage } from "./Communication/MessageParser";
import { VariableMessageType } from "./Communication/VariableMessageType";
import { SubscriptionManager } from "./SubscriptionManager";

export class VariableMesssageBroker {
  private readonly subscriptionManager: SubscriptionManager = new SubscriptionManager();

  constructor(private readonly scriptrunner: any) {

  }

  receiveMessage(jsonMessage: string): void {
    try {
      const message = parseMessage(jsonMessage);

      if (message !== null) {
        switch(message.messageType) {
          case VariableMessageType.GetRemote: {
            this.subscriptionManager.addSubscriber(message.instanceId, message.messageData.variableName, message.source);

            this.scriptrunner.sendMessageToScript(message.instanceId, message);
            break;
          }

          case VariableMessageType.GetRemoteResponse: {
            this.scriptrunner.sendMessageToScript(message.instanceId, message);
            break;
          }

          case VariableMessageType.Added:
          case VariableMessageType.Changed: {
            const subscribers = this.subscriptionManager.getSubscribers(message.instanceId, message.messageData.variableName);

            subscribers.map((subscriber) => {
              this.scriptrunner.sendMessageToScript(subscriber, message);
            });

            break;
          }
        }
      }
    } catch (error: any) {
      console.warn(error.message);
    }
  }

  reset(): void {
    this.subscriptionManager.reset();
  }
}
