"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MethodDescriptor = void 0;
class MethodDescriptor {
    constructor(name, parameters, actions, description, returnType = '', factory = true, orderId = 0) {
        this.name = name;
        this.parameters = parameters;
        this.actions = actions;
        this.description = description;
        this.returnType = returnType;
        this.factory = factory;
        this.orderId = orderId;
    }
    static getMethodsFromEntryCode(entryCode) {
        const methodsStartSeparator = '/* Methods */';
        const methodsEndSeparator = '/* Methods end */';
        const codeFromStartSeparator = entryCode.substring(entryCode.indexOf(methodsStartSeparator) + methodsStartSeparator.length);
        const codeToEndSeparator = codeFromStartSeparator.substring(codeFromStartSeparator.indexOf('@method'), codeFromStartSeparator.indexOf(methodsEndSeparator));
        const methods = codeToEndSeparator.split('@method ');
        const methodsData = {};
        methods.map((method) => {
            if (method.indexOf('@returns') == -1)
                return;
            const methodDescriptor = method
                .substring(0, method.indexOf('*/'))
                .replace(/\r\n/g, '\n')
                .split('\n');
            const methodName = methodDescriptor[0].toString();
            methodsData[methodName] = {
                returnType: '',
                code: '',
                description: ''
            };
            for (const line of methodDescriptor) {
                if (/@(returns|description)/.test(line)) {
                    const returnMatches = line.match(/(@returns) (\{[a-zA-Z]+\})/);
                    const descriptionMatches = line.match(/(@description) (\{.+\})/);
                    if (returnMatches !== null) {
                        methodsData[methodName].returnType = returnMatches[2].replace(/(\{|\})/g, '');
                    }
                    if (descriptionMatches !== null) {
                        methodsData[methodName].description = decodeURIComponent(descriptionMatches[2].replace(/(\{|\})/g, ''));
                    }
                }
            }
            const methodSourceCodeWithParams = method.substring(method.indexOf('async')).replace(/\r\n/g, '\n');
            const methodSourceCode = methodSourceCodeWithParams.substring(methodSourceCodeWithParams.indexOf('\n') + 1, methodSourceCodeWithParams.lastIndexOf('}'));
            methodsData[methodName].code = methodSourceCode;
        });
        return methodsData;
    }
}
exports.MethodDescriptor = MethodDescriptor;
//# sourceMappingURL=MethodDescriptor.js.map