"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Rule = void 0;
class Rule {
    constructor(name, _enabled = true, triggers, condition) {
        this.name = name;
        this._enabled = _enabled;
        this.triggers = triggers;
        this.condition = condition;
        this.action = () => {
            console.warn(`Action was called before setAction was called for rule with name ${this.name}`);
        };
        if (this._enabled === true) {
            this.subscribeToTrigger();
        }
    }
    setAction(action) {
        this.action = action;
    }
    get enabled() {
        return this._enabled;
    }
    set enabled(value) {
        if (value === true) {
            this.subscribeToTrigger();
        }
        else {
            this.triggers.removeListener();
        }
    }
    subscribeToTrigger() {
        this.triggers.onTriggered((...args) => {
            if (this.condition) {
                if (this.condition.evaluate(...args)) {
                    this.action(...args);
                }
            }
            else {
                this.action(...args);
            }
        });
    }
}
exports.Rule = Rule;
//# sourceMappingURL=Rule.js.map