import { ConditionInterface } from "@lightware/condition-api";
import { Trigger, TriggerType } from "./Trigger";
import { RemoteVariable } from "@lightware/variable-api";


class VariableChangedToTriggerBase extends Trigger {
  constructor(protected readonly variable: RemoteVariable,
              protected readonly triggerCondition: ConditionInterface,
              triggerType: TriggerType.VariableChangedToValue | TriggerType.VariableChangedIntoRange,
              durationMs = 0,
              onInit = true) {

    super(triggerType, durationMs);

    const onChangedHandler = (currentValue: any, previousValue: any): void => {
      if (this.triggerCondition.evaluate(currentValue, previousValue)) {
        this.start();
      } else {
        this.reset();
      }
    };

    this.variable.onChanged(onChangedHandler);

    if (onInit) {
      onChangedHandler(this.variable.value, this.variable.previousValue);
    }
  }
}

export class VariableChangedToValueTrigger extends VariableChangedToTriggerBase {
  constructor(variable: RemoteVariable, triggerCondition: ConditionInterface, durationMs = 0, onInit = true) {

    super(variable, triggerCondition, TriggerType.VariableChangedToValue, durationMs, onInit);
  }
}

export class VariableChangedIntoRangeTrigger extends VariableChangedToTriggerBase {
  constructor(variable: RemoteVariable, triggerCondition: ConditionInterface, durationMs = 0, onInit = true) {

    super(variable, triggerCondition, TriggerType.VariableChangedIntoRange, durationMs, onInit);
  }
}