"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LocalVariable = void 0;
const node_events_1 = require("node:events");
const Variable_1 = require("./Variable");
const EventNames_1 = require("./EventNames");
var InternalEventNames;
(function (InternalEventNames) {
    InternalEventNames["ChangedInternal"] = "changedInternal";
})(InternalEventNames || (InternalEventNames = {}));
class LocalVariable {
    constructor(name, typeSignature, _ownerId, defaultValue = undefined) {
        this.name = name;
        this.typeSignature = typeSignature;
        this._ownerId = _ownerId;
        this._currentValue = undefined;
        this._previousValue = undefined;
        this._lastModifiedMs = -1;
        this.eventEmitter = new node_events_1.EventEmitter();
        this.setInternalState(defaultValue);
    }
    get ownerId() {
        return this._ownerId;
    }
    get value() {
        return this._currentValue;
    }
    set value(value) {
        this.setInternalState(value);
    }
    get previousValue() {
        return this._previousValue;
    }
    get lastModifiedMs() {
        return this._lastModifiedMs;
    }
    onValid(listener) {
        this.eventEmitter.on(EventNames_1.EventNames.Valid, listener);
    }
    onInvalid(listener) {
        this.eventEmitter.on(EventNames_1.EventNames.Invalid, listener);
    }
    onChanged(listener) {
        this.eventEmitter.on(EventNames_1.EventNames.Changed, listener);
    }
    onChangedInternal(listener) {
        this.eventEmitter.on(InternalEventNames.ChangedInternal, listener);
    }
    setInternalState(value) {
        // It is necessary to manage the variables of the factory modules
        if (value == null) {
            value = undefined;
        }
        this.checkAndWarnTypeSignature(value);
        if (this._currentValue != value) {
            let stateChange = Variable_1.StateChange.None;
            if (this._currentValue === undefined && value !== undefined) {
                stateChange = Variable_1.StateChange.ToValid;
            }
            else if (this._currentValue !== undefined && value === undefined) {
                stateChange = Variable_1.StateChange.ToInvalid;
            }
            this._previousValue = this._currentValue;
            this._currentValue = value;
            this._lastModifiedMs = performance.now();
            if (stateChange == Variable_1.StateChange.ToValid) {
                this.eventEmitter.emit(EventNames_1.EventNames.Valid);
            }
            else if (stateChange == Variable_1.StateChange.ToInvalid) {
                this.eventEmitter.emit(EventNames_1.EventNames.Invalid);
            }
            this.eventEmitter.emit(EventNames_1.EventNames.Changed, this._currentValue, this._previousValue);
            this.eventEmitter.emit(InternalEventNames.ChangedInternal, this);
        }
    }
    checkAndWarnTypeSignature(value) {
        return;
        if (typeof value !== this.typeSignature && typeof value !== 'undefined') {
            console.warn(`The variable, ${this.ownerId}.${this.name}, is tried to be set with incompatible value! The provided value type is ${typeof value}, the expected type is ${this.typeSignature}`);
        }
    }
}
exports.LocalVariable = LocalVariable;
//# sourceMappingURL=LocalVariable.js.map