import { VariableMessage } from "./Communication/MessageParser";
import { TypeSignature, Variable, VariableType } from "./Variable";
export declare class RemoteVariable implements Variable {
    private readonly name;
    private readonly _ownerId;
    typeSignature: TypeSignature;
    private _currentValue;
    private _previousValue;
    private _lastModifiedMs;
    private readonly eventEmitter;
    constructor(name: string, _ownerId: string);
    isValid(): boolean;
    get ownerId(): string;
    get value(): VariableType;
    set value(_value: VariableType);
    get previousValue(): VariableType;
    get lastModifiedMs(): number;
    onValid(listener: () => void): void;
    onInvalid(listener: () => void): void;
    onChanged(listener: (currentValue: VariableType, previousValue: VariableType) => void): void;
    onMessage(message: VariableMessage): void;
    private setLastModifiedMs;
    private setInternalState;
}
