"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const LocalVariable_1 = require("../LocalVariable");
const Variable_1 = require("../Variable");
describe('LocalVariable', () => {
    afterEach(() => {
        jest.clearAllMocks();
    });
    test('Successfully create a LocalVariable', () => {
        expect(() => {
            new LocalVariable_1.LocalVariable("cica", Variable_1.TypeSignature.String, "", 5);
        }).not.toThrow();
    });
    test('create variable with undefined default value', () => {
        const localVariable = new LocalVariable_1.LocalVariable("cica6", Variable_1.TypeSignature.String, "cica6");
        expect(typeof localVariable.value).toBe("undefined");
    });
    test('set currentValue successfully changes the value', () => {
        let newValue = 5;
        const localVariable = new LocalVariable_1.LocalVariable("cica", Variable_1.TypeSignature.String, "", newValue);
        expect(localVariable.value).toBe(newValue);
        newValue = 6;
        localVariable.value = newValue;
        expect(localVariable.value).toBe(newValue);
    });
    test('set currentValue successfully changes the value of an already set value', () => {
        let newValue = 5;
        const localVariable = new LocalVariable_1.LocalVariable("cica", Variable_1.TypeSignature.String, "", newValue);
        newValue = 6;
        localVariable.value = newValue;
        newValue = 7;
        localVariable.value = newValue;
        expect(localVariable.value).toBe(newValue);
    });
    test('set currentValue successfully changes the value onchanged called, but not calledd when subscricption occurs', () => {
        const localVariable = new LocalVariable_1.LocalVariable("cica", Variable_1.TypeSignature.String, "", 5);
        const onChangeHandler = jest.fn();
        localVariable.onChanged(onChangeHandler);
        localVariable.value = 6;
        expect(onChangeHandler).toHaveBeenCalledTimes(1);
        expect(onChangeHandler).nthCalledWith(1, 6, 5);
    });
    test('get ownerId', () => {
        const localVariable = new LocalVariable_1.LocalVariable("cica", Variable_1.TypeSignature.String, "cica", 5);
        expect(localVariable.ownerId).toBe("cica");
    });
    test('set currentValue successfully changes the value onchanged called', () => {
        const localVariable = new LocalVariable_1.LocalVariable("cica2", Variable_1.TypeSignature.String, "cica2", 5);
        const time = localVariable.lastModifiedMs;
        localVariable.value = 6;
        expect(localVariable.value).toBe(6);
        expect(localVariable.previousValue).toBe(5);
        expect(localVariable.lastModifiedMs).toBeGreaterThan(time);
    });
    test('onValid event called with onMessage(VariableChangedMessage)', () => {
        const localVariable = new LocalVariable_1.LocalVariable("cica3", Variable_1.TypeSignature.String, "cica3");
        const onValidHandler = jest.fn();
        localVariable.onValid(onValidHandler);
        localVariable.value = 10;
        expect(onValidHandler).toHaveBeenCalledTimes(1);
    });
    test('onInvalid event called', () => {
        const localVariable = new LocalVariable_1.LocalVariable("cica4", Variable_1.TypeSignature.Boolean, "cica4", true);
        const onInvalidHandler = jest.fn();
        localVariable.onInvalid(onInvalidHandler);
        localVariable.value = undefined;
        expect(onInvalidHandler).toHaveBeenCalledTimes(1);
    });
    test('onChanged event called when variable changed, but not calledd when subscricption occurs', () => {
        const localVariable = new LocalVariable_1.LocalVariable("cica5", Variable_1.TypeSignature.String, "cica5", 5);
        const onChangedHandler = jest.fn();
        localVariable.onChanged(onChangedHandler);
        localVariable.value = 10;
        expect(onChangedHandler).toHaveBeenCalledTimes(1);
    });
    test('onChangedInternal event called', () => {
        const localVariable = new LocalVariable_1.LocalVariable("cica6", Variable_1.TypeSignature.String, "cica6", 5);
        const onChangedInternal = jest.fn();
        localVariable.onChangedInternal(onChangedInternal);
        localVariable.value = 10;
        expect(typeof localVariable.value).toBe("number");
        expect(onChangedInternal).toHaveBeenCalledTimes(1);
    });
});
//# sourceMappingURL=LocalVariable.test.js.map