import { ValueType } from "./ModuleDescriptorObject";
export declare class ActionsDescriptor {
    readonly code: string;
    readonly type: ActionType;
    steps: StepDescriptor[];
    constructor(code?: string, type?: ActionType, steps?: StepDescriptor[]);
    migrateConstParameter(value: ValueType): ConstantParameter;
    migrateParameter(value: (StepParameter[] | StepParameter)): StepParameter[] | StepParameter;
    migrateMethodParameters(s: StepDescriptor, property: string): StepDescriptor;
    migrateSteps(): void;
}
export declare enum ActionType {
    Wizard = "wizard",
    Code = "code"
}
export type StepDescriptor = {
    name: string;
    description: string;
    type: StepType;
    step: MethodCallStep | SetVariableStep | EventEmitStep | TimeoutStep | LogStep | HtmlTextStep | HtmlInnerStep | HtmlStyleStep | HtmlHideStep | UpdateStatusStep | HtmlClassStep | HtmlElementValueStep;
};
export declare enum StepType {
    MethodCall = "MethodCall",
    EventEmit = "EventEmit",
    Timeout = "Timeout",
    Log = "Log",
    SetVariable = "SetVariable"
}
export type SetVariableStep = {
    instanceId: string;
    variableName: string;
    variableValue: StepParameter;
    variableType: string;
};
export type MethodCallStep = {
    instanceId: string;
    methodName: string;
    methodParameters: StepParameter[];
};
export type EventEmitStep = {
    eventName: string;
    eventParameters: StepParameter[];
};
export type TimeoutStep = {
    waitTimeMs: StepParameter;
};
export type LogStep = {
    message: StepParameter;
};
export type HtmlTextStep = {
    elementId: string;
    text: StepParameter;
};
export type HtmlInnerStep = {
    elementId: string;
    innerHtml: StepParameter;
};
export type HtmlStyleStep = {
    elementId: string;
    cssPropertyName: string;
    cssPropertyValue: StepParameter;
};
export type HtmlHideStep = {
    elementId: string;
    display: string;
};
export declare enum UpdateStatusStepTheme {
    Default = "Default",
    Success = "Success",
    Warning = "Warning",
    Error = "Error"
}
export type UpdateStatusStep = {
    label: string;
    value: StepParameter;
    themeColor: UpdateStatusStepTheme;
};
export type HtmlClassStep = {
    elementId: string;
    cssClassName: StepParameter;
};
export type HtmlElementValueStep = {
    elementId: string;
    htmlElementValue: StepParameter;
};
export declare enum StepParameterType {
    EventParameter = "eventParameter",
    Constant = "constant",
    InstanceParameter = "instanceParameter"
}
export type StepParameter = EventParameter | ConstantParameter | InstanceParameter;
export type EventParameter = {
    parameterType: StepParameterType.EventParameter;
    paramName: string;
};
export type ConstantParameter = {
    parameterType: StepParameterType.Constant;
    value: ValueType;
};
export type InstanceParameter = {
    parameterType: StepParameterType.InstanceParameter;
    paramName: string;
};
