"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VariableChangedIntoRangeTrigger = exports.VariableChangedToValueTrigger = void 0;
const Trigger_1 = require("./Trigger");
class VariableChangedToTriggerBase extends Trigger_1.Trigger {
    constructor(variable, triggerCondition, triggerType, durationMs = 0, onInit = true) {
        super(triggerType, durationMs);
        this.variable = variable;
        this.triggerCondition = triggerCondition;
        const onChangedHandler = (currentValue, previousValue) => {
            if (this.triggerCondition.evaluate(currentValue, previousValue)) {
                this.start();
            }
            else {
                this.reset();
            }
        };
        this.variable.onChanged(onChangedHandler);
        if (onInit) {
            onChangedHandler(this.variable.value, this.variable.previousValue);
        }
    }
}
class VariableChangedToValueTrigger extends VariableChangedToTriggerBase {
    constructor(variable, triggerCondition, durationMs = 0, onInit = true) {
        super(variable, triggerCondition, Trigger_1.TriggerType.VariableChangedToValue, durationMs, onInit);
    }
}
exports.VariableChangedToValueTrigger = VariableChangedToValueTrigger;
class VariableChangedIntoRangeTrigger extends VariableChangedToTriggerBase {
    constructor(variable, triggerCondition, durationMs = 0, onInit = true) {
        super(variable, triggerCondition, Trigger_1.TriggerType.VariableChangedIntoRange, durationMs, onInit);
    }
}
exports.VariableChangedIntoRangeTrigger = VariableChangedIntoRangeTrigger;
//# sourceMappingURL=VariableTrigger.js.map