import { ConditionInterface } from "@lightware/condition-api";
import { Triggers } from "../Triggers/Triggers";

export class Rule {
  private action: (...args: any[]) => void = () => {
    console.warn(`Action was called before setAction was called for rule with name ${this.name}`);
  };

  constructor(public readonly name: string,
              private _enabled: boolean = true,
              private readonly triggers: Triggers,
              private readonly condition?: ConditionInterface) {

    if (this._enabled === true) {
      this.subscribeToTrigger();
    }
  }

  setAction(action: (...args: any[]) => void): void {
    this.action = action;
  }

  get enabled(): boolean {
    return this._enabled;
  }

  set enabled(value: boolean) {
    if (value === true) {
      this.subscribeToTrigger();
    } else {
      this.triggers.removeListener();
    }
  }

  private subscribeToTrigger(): void {
    this.triggers.onTriggered((...args: any[]) => {
      if (this.condition) {
        if (this.condition.evaluate(...args)) {
          this.action(...args);
        }
      } else {
        this.action(...args);
      }
    });
  }
}
