"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VariableMesssageBroker = void 0;
const MessageParser_1 = require("./Communication/MessageParser");
const VariableMessageType_1 = require("./Communication/VariableMessageType");
const SubscriptionManager_1 = require("./SubscriptionManager");
class VariableMesssageBroker {
    constructor(scriptrunner) {
        this.scriptrunner = scriptrunner;
        this.subscriptionManager = new SubscriptionManager_1.SubscriptionManager();
    }
    receiveMessage(jsonMessage) {
        try {
            const message = (0, MessageParser_1.parseMessage)(jsonMessage);
            if (message !== null) {
                switch (message.messageType) {
                    case VariableMessageType_1.VariableMessageType.GetRemote: {
                        this.subscriptionManager.addSubscriber(message.instanceId, message.messageData.variableName, message.source);
                        this.scriptrunner.sendMessageToScript(message.instanceId, message);
                        break;
                    }
                    case VariableMessageType_1.VariableMessageType.GetRemoteResponse: {
                        this.scriptrunner.sendMessageToScript(message.instanceId, message);
                        break;
                    }
                    case VariableMessageType_1.VariableMessageType.Added:
                    case VariableMessageType_1.VariableMessageType.Changed: {
                        const subscribers = this.subscriptionManager.getSubscribers(message.instanceId, message.messageData.variableName);
                        subscribers.map((subscriber) => {
                            this.scriptrunner.sendMessageToScript(subscriber, message);
                        });
                        break;
                    }
                }
            }
        }
        catch (error) {
            console.warn(error.message);
        }
    }
    reset() {
        this.subscriptionManager.reset();
    }
}
exports.VariableMesssageBroker = VariableMesssageBroker;
//# sourceMappingURL=VariableMessageBroker.js.map