import { VariableMessageType } from "./VariableMessageType";
import { VariableMessage, parseMessage } from "./MessageParser";

describe('MessagePareser test', () => {
  test('Parsing Changed massage', () => {
    const message = {
      messageId: 'msg1',
      instanceId: 'taurus',
      source: 'source',
      messageType: 'variable/changed',
      messageData: {
        variableName: 'var1',
        currentValue: 10,
        previousValue: 20,
        lastModifiedMs: 123,
        typeSignature: 'number'
      }
    };

    expect(() => parseMessage(JSON.stringify(message))).not.toThrow();

    const variableMessage: VariableMessage = parseMessage(JSON.stringify(message));

    expect(variableMessage!.messageType).toBe(VariableMessageType.Changed);
  });

  test('Parsing variable/added massage', () => {
    const message = {
      messageId: 'msg1',
      instanceId: 'taurus',
      source: 's',
      messageType: 'variable/added',
      messageData: {
        variableName: 'var1',
        currentValue: 10,
        previousValue: 20,
        lastModifiedMs: 123,
        typeSignature: 'number'
      }
    };

    expect(() => parseMessage(JSON.stringify(message))).not.toThrow();

    const variableMessage: VariableMessage = parseMessage(JSON.stringify(message));

    expect(variableMessage!.messageType).toBe(VariableMessageType.Added);
  });

  test('Parsing variable/getRemote massage', () => {
    const message = {
      messageId: 'msg1',
      instanceId: 'taurus',
      source: 's',
      messageType: 'variable/getRemote',
      messageData: {
        variableName: 'var1',
        currentValue: 10,
        previousValue: 20,
        lastModifiedMs: 123,
        typeSignature: 'number'
      }
    };

    expect(() => parseMessage(JSON.stringify(message))).not.toThrow();

    const variableMessage: VariableMessage = parseMessage(JSON.stringify(message));

    expect(variableMessage!.messageType).toBe(VariableMessageType.GetRemote);
  });

  test('Parsing variable/getRemoteResponse massage', () => {
    const message = {
      messageId: 'msg1',
      instanceId: 'taurus',
      source: 's',
      messageType: 'variable/getRemoteResponse',
      messageData: {
        variableName: 'var1',
        currentValue: 10,
        previousValue: 20,
        lastModifiedMs: 123,
        typeSignature: 'number'
      }
    };

    expect(() => parseMessage(JSON.stringify(message))).not.toThrow();

    const variableMessage: VariableMessage = parseMessage(JSON.stringify(message));

    expect(variableMessage!.messageType).toBe(VariableMessageType.GetRemoteResponse);
  });

  test('Parsing Wrong message type', () => {
    const message = {
      messageId: 'msg1',
      instanceId: 'taurus',
      source: 'source',
      messageType: 'wrongType',
      messageData: {
        variableName: 'var1',
        ownerId: 'taurus',
        currentValue: 10,
        previousValue: 20,
        lastModifiedMs: 123,
        typeSignature: 'number'
      }
    };

    expect(parseMessage(JSON.stringify(message))).toBeNull();
  });
});