import { VariableAddedMessage } from "./VariableAddedMessage"
import { VariableChangedMessage } from "./VariableChangedMessage"
import { VariableGetRemoteMessage } from "./VariableGetRemoteMessage"
import { VariableGetRemoteResponse } from "./VariableGetRemoteResponse"
import { VariableMessageType } from "./VariableMessageType"

export type VariableMessageOnRemote = VariableChangedMessage |
VariableAddedMessage |
VariableGetRemoteResponse;

export type VariableMessage = VariableChangedMessage |
                               VariableAddedMessage |
                               VariableGetRemoteMessage |
                               VariableGetRemoteResponse |
                               null;

export const parseMessage = (jsonString: string): VariableMessage => {
  const jsonObject = JSON.parse(jsonString);

  switch(jsonObject.messageType) {
    case VariableMessageType.Changed:
      return Object.setPrototypeOf(jsonObject, VariableChangedMessage.prototype);

    case VariableMessageType.Added:
      return Object.setPrototypeOf(jsonObject, VariableAddedMessage.prototype);

    case VariableMessageType.GetRemote:
      return Object.setPrototypeOf(jsonObject, VariableGetRemoteMessage.prototype);

    case VariableMessageType.GetRemoteResponse:
      return Object.setPrototypeOf(jsonObject, VariableGetRemoteResponse.prototype);
  }

  return null;
}