export type VariableType = number | string | boolean | object | undefined;

export enum TypeSignature {
  String = 'string',
  Number = 'number',
  Boolean = 'boolean',
  Object = 'object',
  Undefined = 'undefined'
};

export enum StateChange {
  None,
  ToValid,
  ToInvalid
}

export interface Variable {
  get ownerId(): string;

  get value(): VariableType;
  set value(value: VariableType);

  get previousValue(): VariableType;

  get lastModifiedMs(): number;

  onValid(listener: () => void): void;
  onInvalid(listener: () => void): void;
  onChanged(listener: (currentValue: VariableType, previousValue: VariableType) => void): void;
}
